%Read the xlsx file with word counts
M = readmatrix('Source_datasets/random_regulations_data.xlsx');
M = M(2:end,2:end);
nText = size(M);
nText = nText(1);

%Count matrix, 41 x 8 with:
%1: Unique Operands
%2: Unique Mathematical Operators
%3: Unique Logical Operators
%4: Unique Regulatory Operators
%5: Total Operands
%6: Total Mathematical Operators
%7: Total Logical Operators
%8: Total Regulatory Operators

MCount = zeros(41,8);

%Iterate over 41 regulations (last one being the total)
for i=1:41
    
    %Iterate over 4 "unique" measures
    for j=1:4
    
        %Iterate over all words
        for k=1:nText
        MCount(i,j) = MCount(i,j) + min(M(k,i+5),1)*M(k,j+1);
        end
       
        
    end
    
    %Iterate over 4 "total" measures
    for j=5:8
            
        %Iterate over 96 words
        for k=1:nText
        MCount(i,j) = MCount(i,j) + M(k,i+5)*M(k,j-4+1);
        end
        
    end

end

%We now produce a 41 x 6 matrix with the following measures:
%1: Length
%2: Cyclomatic complexity
%3: Quantity of regulations
%4: Potential volume
%5: Operator diversity
%6: Level

MeasuresText = zeros(41,6);

%Iterating over 41 regulations
for i=1:41
MeasuresText(i,1) = sum(MCount(i,5:8));
MeasuresText(i,2) = MCount(i,7);
MeasuresText(i,3) = MCount(i,8);
MeasuresText(i,4) = 2 + MCount(i,1);
MeasuresText(i,5) = sum(MCount(i,2:4));
MeasuresText(i,6) = MeasuresText(i,4)/MeasuresText(i,1);
end

%Save Table with measures.
T=0:1:40;
Measures = [T' MeasuresText MCount];
Measures_Table = round(Measures,2);
Measures_Table = array2table(Measures_Table,'VariableNames',{'Regulation','Length','Cyclomatic','Quantity','Potential Volume','Operator Diversity','Level','Unique Operands','Unique M Operators', 'Unique L Operators', 'Unique R Operators','Total Operands','Total M Operators', 'Total L Operators', 'Total R Operators'});

writetable(Measures_Table,'Datasets/Measures.csv'); 
