//Directory for Windows user:
//cd %systemdrive%\Users\%username%\Downloads\Codes\04_Experiments\
//Directory for MacOS user:
//cd ~/Downloads/04_Experiments/

use "Datasets/main.dta", replace

//Create a dataset with 38 regulations and frequency of mistakes.

collapse(mean) is_correct time length cyclomatic quantity potentialvolume operatordiversity level uniqueoperands uniquemoperators uniqueloperators uniqueroperators totaloperands totalmoperators totalloperators totalroperators, by(id_regulation)

//0. Descriptive Statistics
gen mistake = 1-is_correct
sum mistake, d

//1. Correlation of different measures with mistake, controlling for length.

quietly reg mistake length, robust
estimates store regr3_1
quietly reg mistake length cyclomatic, robust
estimates store regr3_2
quietly reg mistake length quantity, robust
estimates store regr3_3
quietly reg mistake length potentialvolume, robust
estimates store regr3_4
quietly reg mistake length operatordiversity, robust
estimates store regr3_5
quietly reg mistake length level, robust
estimates store regr3_6

// Table OA.10
estout regr3_1 regr3_2 regr3_3 regr3_4 regr3_5 regr3_6, cells(b(star fmt(3)) t(par fmt(2))) stats(r2_a, fmt(3) labels(R2_a))  style(tex) keep(length cyclomatic quantity potentialvolume operatordiversity level) starlevels(* 0.10 ** 0.05 *** 0.01) ///
legend label collabels(none)  type
