//Directory for Windows user:
//cd %systemdrive%\Users\%username%\Downloads\Codes\04_Experiments\
//Directory for MacOS user:
//cd ~/Downloads/04_Experiments/

//1. Delete incorrect answers, winsorize outliers
use "Datasets/main.dta", replace

//Convert time into number of seconds
rename time time2
generate time = 60*mm(time2)+ss(time2)
drop time2

drop if is_correct==0
replace time = 579 if time > 579

//Correlation of different measures with time, controlling for length. Outliers winsorized.

quietly reg time length i.id_question i.user, robust 
estimates store regr3_1
quietly reg time length cyclomatic i.id_question i.user, robust 
estimates store regr3_2
quietly reg time length quantity i.id_question i.user, robust 
estimates store regr3_3
quietly reg time length potentialvolume i.id_question i.user, robust 
estimates store regr3_4
quietly reg time length operatordiversity i.id_question i.user, robust 
estimates store regr3_5
quietly reg time length level i.id_question i.user, robust 
estimates store regr3_6

// Table OA.19
estout regr3_1 regr3_2 regr3_3 regr3_4 regr3_5 regr3_6, cells(b(star fmt(3)) t(par fmt(2))) stats(r2_a, fmt(3) labels(R2_a))  style(tex) keep(length cyclomatic quantity potentialvolume operatordiversity level) starlevels(* 0.10 ** 0.05 *** 0.01) ///
legend label collabels(none)  type

************************************************************

//2. Delete incorrect answers, keep all outliers
use "Datasets/main.dta", replace

//Convert time into number of seconds
rename time time2
generate time = 60*mm(time2)+ss(time2)
drop time2

drop if is_correct==0

//Correlation of different measures with time, controlling for length. All outliers kept.

quietly reg time length i.id_question i.user, robust 
estimates store regr3_1
quietly reg time length cyclomatic i.id_question i.user, robust 
estimates store regr3_2
quietly reg time length quantity i.id_question i.user, robust 
estimates store regr3_3
quietly reg time length potentialvolume i.id_question i.user, robust 
estimates store regr3_4
quietly reg time length operatordiversity i.id_question i.user, robust 
estimates store regr3_5
quietly reg time length level i.id_question i.user, robust 
estimates store regr3_6

// Table OA.20
estout regr3_1 regr3_2 regr3_3 regr3_4 regr3_5 regr3_6, cells(b(star fmt(3)) t(par fmt(2))) stats(r2_a, fmt(3) labels(R2_a))  style(tex) keep(length cyclomatic quantity potentialvolume operatordiversity level) starlevels(* 0.10 ** 0.05 *** 0.01) ///
legend label collabels(none)  type

************************************************************

//3. Keep incorrect answers, exclude outliers

use "Datasets/main.dta", replace

//Convert time into number of seconds
rename time time2
generate time = 60*mm(time2)+ss(time2)
drop time2

drop if time >= 579

//Correlation of different measures with time, controlling for length. Outliers excluded, incorrect answers kept.

quietly reg time length i.id_question i.user, robust 
estimates store regr3_1
quietly reg time length cyclomatic i.id_question i.user, robust 
estimates store regr3_2
quietly reg time length quantity i.id_question i.user, robust 
estimates store regr3_3
quietly reg time length potentialvolume i.id_question i.user, robust 
estimates store regr3_4
quietly reg time length operatordiversity i.id_question i.user, robust 
estimates store regr3_5
quietly reg time length level i.id_question i.user, robust 
estimates store regr3_6

// Table OA.21
estout regr3_1 regr3_2 regr3_3 regr3_4 regr3_5 regr3_6, cells(b(star fmt(3)) t(par fmt(2))) stats(r2_a, fmt(3) labels(R2_a))  style(tex) keep(length cyclomatic quantity potentialvolume operatordiversity level) starlevels(* 0.10 ** 0.05 *** 0.01) ///
legend label collabels(none)  type


************************************************************

//4. Keep all observations

use "Datasets/main.dta", replace

//Convert time into number of seconds
rename time time2
generate time = 60*mm(time2)+ss(time2)
drop time2

//Correlation of different measures with time, not controlling for length. All observations kept.

quietly reg time length i.id_question i.user, robust 
estimates store regr3_1
quietly reg time length cyclomatic i.id_question i.user, robust 
estimates store regr3_2
quietly reg time length quantity i.id_question i.user, robust 
estimates store regr3_3
quietly reg time length potentialvolume i.id_question i.user, robust 
estimates store regr3_4
quietly reg time length operatordiversity i.id_question i.user, robust 
estimates store regr3_5
quietly reg time length level i.id_question i.user, robust 
estimates store regr3_6

// Table OA.22 
estout regr3_1 regr3_2 regr3_3 regr3_4 regr3_5 regr3_6, cells(b(star fmt(3)) t(par fmt(2))) stats(r2_a, fmt(3) labels(R2_a))  style(tex) keep(length cyclomatic quantity potentialvolume operatordiversity level) starlevels(* 0.10 ** 0.05 *** 0.01) ///
legend label collabels(none)  type
