//Directory for Windows user:
//cd %systemdrive%\Users\%username%\Downloads\Codes\03_EBA\
//Directory for MacOS user:
//cd ~/Downloads/Codes/03_EBA/

use "Datasets/EBA_Master.dta", clear

keep id_name Attributes_uniq Attributes_tot EconOp_uniq EconOp_tot FctWords_uniq FctWords_tot LegalRef_uniq LegalRef_tot LogicalConn_uniq LogicalConn_tot MathOp_uniq MathOp_tot Other_uniq Other_tot RegOp_uniq RegOp_tot name_entity

gen length = Attributes_tot + EconOp_tot + FctWords_tot + LegalRef_tot + LogicalConn_tot + MathOp_tot + Other_tot + RegOp_tot
gen operands_unique = Attributes_uniq + EconOp_uniq
gen operands_tot = Attributes_tot + EconOp_tot
gen operators_unique = LogicalConn_uniq + MathOp_uniq + RegOp_uniq
gen operators_tot = LogicalConn_tot + MathOp_tot + RegOp_tot

gen quantity = RegOp_tot
gen cyclomatic = LogicalConn_tot
gen potential = 2+operands_unique
gen diversity = operators_unique

gen level = potential/length
gen quantity_n = quantity/length
gen cyclomatic_n = cyclomatic/length
gen diversity_n = diversity/length

// Table OA.8 + 9: Summary statistics, by template
quietly estpost tabstat length cyclomatic_n quantity_n level  diversity_n, by(name_entity) nototal
esttab, cells("length(label(`:var lab length') fmt(%12.0fc)) cyclomatic_n(label(`:var lab cyclomatic') fmt(%12.2fc)) quantity_n(label(`:var lab quantity') fmt(%12.2fc)) diversity_n(label(`:var lab diversity') fmt(%12.2fc)) level(label(`:var lab level') fmt(%12.2fc))") ///
noobs nomtitle nonumber varlabels(`e(labels)') varwidth(20) tex






	
