//Directory for Windows user:
//cd %systemdrive%\Users\%username%\Downloads\Codes\03_EBA\
//Directory for MacOS user:
// cd ~/Downloads/Codes/03_EBA/
version 18
use "Datasets/EBA_Master_Regulators.dta", clear

keep name_entity Attributes_uniq Attributes_tot EconOp_uniq EconOp_tot FctWords_uniq FctWords_tot LegalRef_uniq LegalRef_tot LogicalConn_uniq LogicalConn_tot MathOp_uniq MathOp_tot Other_uniq Other_tot RegOp_uniq RegOp_tot name_entity highly important less not noview

gen operands_unique = Attributes_uniq + EconOp_uniq
gen operands_tot = Attributes_tot + EconOp_tot
gen operators_unique = LogicalConn_uniq + MathOp_uniq + RegOp_uniq
gen operators_tot = LogicalConn_tot + MathOp_tot + RegOp_tot

gen length = Attributes_tot + EconOp_tot + FctWords_tot + LegalRef_tot + LogicalConn_tot + MathOp_tot + Other_tot + RegOp_tot
gen potential = 2+operands_unique
gen diversity = operators_unique
gen level = potential/length
gen quantity = RegOp_tot
gen cyclomatic = LogicalConn_tot

gen average = (3*highly + 2*important + 1*less)/(highly+important+less+not)

//1. Correlation of different measures with average importance, controlling for length.

quietly reg average length, robust
estimates store regr1_1
quietly reg average length cyclomatic, robust
estimates store regr1_2
quietly reg average length quantity, robust
estimates store regr1_3
quietly reg average length potential, robust
estimates store regr1_4
quietly reg average length diversity, robust
estimates store regr1_5
quietly reg average length level, robust
estimates store regr1_6

//Table 8
estout regr1_1 regr1_2 regr1_3 regr1_4 regr1_5 regr1_6, cells(b(star fmt(5)) t(par fmt(2))) stats(r2_a, fmt(3) labels(Adjusted-R2))  style(tex) keep(length cyclomatic quantity potential diversity level) starlevels(* 0.10 ** 0.05 *** 0.01) ///
legend label collabels(none)  type


//Additional: negative coefficient is not robust to removing "C70", or large values of quantity.
sum quantity, d

quietly reg average length quantity, robust
estimates store regra_1
quietly reg average length quantity, robust, if name_entity != "C70"
estimates store regra_2
quietly reg average length quantity, robust, if quantity < 5989
estimates store regra_3
quietly reg average length quantity, robust, if quantity < 2567
estimates store regra_4
quietly reg average length quantity, robust, if quantity < 2221
estimates store regra_5
quietly reg average length quantity, robust, if quantity < 868
estimates store regra_6
quietly reg average length quantity, robust, if quantity < 280
estimates store regra_7


// Table Additional
estout regra_1 regra_2 regra_3 regra_4 regra_5 regra_6 regra_7, cells(b(star fmt(5)) t(par fmt(2))) stats(r2_a, fmt(3) labels(Adjusted-R2))  style(tex) keep(length quantity) starlevels(* 0.10 ** 0.05 *** 0.01) ///
legend label collabels(none)  type


//Additional: positive coefficient on potential is robust to removing "C70" or up to 7 templates with highest potential (out of 43)
sum potential, d

quietly reg average length potential, robust
estimates store regrb_1
quietly reg average length potential, robust, if name_entity != "C70"
estimates store regrb_2
quietly reg average length potential, robust, if potential < 371
estimates store regrb_3
quietly reg average length potential, robust, if potential < 294
estimates store regrb_4
quietly reg average length potential, robust, if potential < 279
estimates store regrb_5
quietly reg average length potential, robust, if potential < 250
estimates store regrb_6
quietly reg average length potential, robust, if potential < 240
estimates store regrb_7

// Table Additional
estout regrb_1 regrb_2 regrb_3 regrb_4 regrb_5 regrb_6 regrb_7, cells(b(star fmt(5)) t(par fmt(2))) stats(r2_a, fmt(3) labels(Adjusted-R2))  style(tex) keep(length potential) starlevels(* 0.10 ** 0.05 *** 0.01) ///
legend label collabels(none)  type


// ONLINE APPENDIX. Correlation of different measures with "highly important", controlling for length.

gen important1 = highly/(29-noview)

quietly reg important1 length, robust
estimates store regr2_1
quietly reg important1 length cyclomatic, robust
estimates store regr2_2
quietly reg important1 length quantity, robust
estimates store regr2_3
quietly reg important1 length potential, robust
estimates store regr2_4
quietly reg important1 length diversity, robust
estimates store regr2_5
quietly reg important1 length level, robust
estimates store regr2_6

//Table OA.27
estout regr2_1 regr2_2 regr2_3 regr2_4 regr2_5 regr2_6, cells(b(star fmt(5)) t(par fmt(2))) stats(r2_a, fmt(3) labels(Adjusted-R2))  style(tex) keep(length cyclomatic quantity potential diversity level) starlevels(* 0.10 ** 0.05 *** 0.01) ///
legend label collabels(none)  type


// ONLINE APPENDIX. Correlation of different measures with "highly important or important", controlling for length.
gen important2 = (highly+important)/(29-noview)

quietly reg important2 length, robust
estimates store regr3_1
quietly reg important2 length cyclomatic, robust
estimates store regr3_2
quietly reg important2 length quantity, robust
estimates store regr3_3
quietly reg important2 length potential, robust
estimates store regr3_4
quietly reg important2 length diversity, robust
estimates store regr3_5
quietly reg important2 length level, robust
estimates store regr3_6

// Table OA.28
estout regr3_1 regr3_2 regr3_3 regr3_4 regr3_5 regr3_6, cells(b(star fmt(5)) t(par fmt(2))) stats(r2_a, fmt(3) labels(Adjusted-R2))  style(tex) keep(length cyclomatic quantity potential diversity level) starlevels(* 0.10 ** 0.05 *** 0.01) ///
legend label collabels(none)  type


// ONLINE APPENDIX. Correlation of different measures with "not important", controlling for length.
gen notimportant1 = (not)/(29-noview)

quietly reg notimportant1 length, robust
estimates store regr4_1
quietly reg notimportant1 length cyclomatic, robust
estimates store regr4_2
quietly reg notimportant1 length quantity, robust
estimates store regr4_3
quietly reg notimportant1 length potential, robust
estimates store regr4_4
quietly reg notimportant1 length diversity, robust
estimates store regr4_5
quietly reg notimportant1 length level, robust
estimates store regr4_6

// Table OA.29
estout regr4_1 regr4_2 regr4_3 regr4_4 regr4_5 regr4_6, cells(b(star fmt(5)) t(par fmt(2))) stats(r2_a, fmt(3) labels(Adjusted-R2))  style(tex) keep(length cyclomatic quantity potential diversity level) starlevels(* 0.10 ** 0.05 *** 0.01) ///
legend label collabels(none)  type


// ONLINE APPENDIX. Correlation of different measures with "not important or less important", controlling for length.
gen notimportant2 = (not+less)/(29-noview)

quietly reg notimportant2 length, robust
estimates store regr5_1
quietly reg notimportant2 length cyclomatic, robust
estimates store regr5_2
quietly reg notimportant2 length quantity, robust
estimates store regr5_3
quietly reg notimportant2 length potential, robust
estimates store regr5_4
quietly reg notimportant2 length diversity, robust
estimates store regr5_5
quietly reg notimportant2 length level, robust
estimates store regr5_6

// Table OA.30
estout regr5_1 regr5_2 regr5_3 regr5_4 regr5_5 regr5_6, cells(b(star fmt(5)) t(par fmt(2))) stats(r2_a, fmt(3) labels(Adjusted-R2))  style(tex) keep(length cyclomatic quantity potential diversity level) starlevels(* 0.10 ** 0.05 *** 0.01) ///
legend label collabels(none)  type


// ONLINE APPENDIX. Probit of different measures predicting being in the "most important" templates, controlling for length.
gen top =0
replace top = 1 if average > 2.49

quietly probit top length, robust
estimates store regr6_1
quietly probit top length cyclomatic, robust
estimates store regr6_2
quietly probit top length quantity, robust
estimates store regr6_3
quietly probit top length potential, robust
estimates store regr6_4
quietly probit top length diversity, robust
estimates store regr6_5
quietly probit top length level, robust
estimates store regr6_6

// Table OA.31
estout regr6_1 regr6_2 regr6_3 regr6_4 regr6_5 regr6_6, cells(b(star fmt(5)) t(par fmt(2))) stats(r2_p, fmt(3) labels(Pseudo-R2))  style(tex) keep(length cyclomatic quantity potential diversity level) starlevels(* 0.10 ** 0.05 *** 0.01) ///
legend label collabels(none) type

